function VTPopulate(tDiv2Load, sDivID2Place, sQueryXML)
{
	var tPlaceDiv = document.getElementById(sDivID2Place);

	if (is_nav)
   	saw.replaceContents(tDiv2Load, tPlaceDiv);
   else
      tPlaceDiv.innerHTML = tDiv2Load.innerHTML;
	tPlaceDiv.setAttribute("queryXML", sQueryXML);
	tPlaceDiv.style.width = "auto";
	if (tPlaceDiv.offsetWidth < 200)
	   tPlaceDiv.style.width = "200px";

	saw.removeIFrame(sDivID2Place + "IFrame");
}

function VTPopulateScroll(tSrcDiv, sDestDivId, sQueryXML, bAppend)
{
    var tDestDiv = document.getElementById(sDestDivId);
    var tTotalInfoDiv = saw.getLastChildElement(tSrcDiv);
    
    tDestDiv.setAttribute("queryXML", sQueryXML);
    
    if(tTotalInfoDiv && tTotalInfoDiv.id == "ValueTableScrollInfo")
    {
        var eid = tTotalInfoDiv.getAttribute("eid");
        var total = parseInt(tTotalInfoDiv.getAttribute("total"));
        var nextPage = parseInt(tTotalInfoDiv.getAttribute("nextPage"));
        tSrcDiv.removeChild(tTotalInfoDiv);
        
        var dialogId = sDestDivId.replace(/Choices$/, "Div");
        var dialog = document.getElementById(dialogId);
        var nDup = dialog.editor.removeDup(tSrcDiv);

        var tTotalSpan = document.getElementById(eid + "Total");
        var moreLink = document.getElementById(eid + "More");
        
        if(saw.getFirstChildElement(tSrcDiv))
        {
            if(nextPage > 0)
            {
                var func = "VTSetPage('" + sDestDivId + "', '" + nextPage + "'); return false;";
                moreLink.onclick = new Function("", func);
                moreLink.style.display = "";
            }
            else
                moreLink.style.display = "none";
            
            var oldTotal = 0;
            total -= nDup;   
            
            if(bAppend)
                oldTotal = parseInt(tTotalSpan.getAttribute("total"));
            
            if(!isNaN(oldTotal))   
                total += oldTotal;
                
            tTotalSpan.setAttribute("total", total);
            total = "1 - " + total;
            
            if(nextPage > 0)
                total += '+';
                
            tTotalSpan.innerHTML = total;
         }
         else
         {
            if(nextPage > 0)
                return VTSetPage(sDestDivId, nextPage);
            else
            {
                moreLink.style.display = "none";
                
                if(tTotalSpan.innerHTML.length == 0)
                    tTotalSpan.innerHTML = "0";
                else
                    tTotalSpan.innerHTML = tTotalSpan.innerHTML.replace(/\+$/, "");

                return;
            }
         }
    }
   
    if(bAppend)
    {  // name attr would disappear if += innerHTML
       var tempDiv = document.createElement("div");
       tempDiv.innerHTML = tSrcDiv.innerHTML;
       var children = tempDiv.childNodes;
       var len = children.length;

        var i = 0;
        while( len != 0 )
        {
            if( children[i].nodeType == 1 )
                tDestDiv.appendChild( children[i] );
            else
                i++;

            len--;
        }

    }
    else
       tDestDiv.innerHTML = tSrcDiv.innerHTML;
}

saw.replaceContents = function(tNewNode, tOldNode)
{
   while (tOldNode.childNodes.length > 0)
	   tOldNode.removeChild(tOldNode.childNodes[0]);

	for (var i=0; i<tNewNode.childNodes.length; i++)
	{
	   var tFromNode = tNewNode.childNodes[i];
      if (tFromNode.nodeType == 1)
      {
   	   var tTemp = tOldNode.appendChild(document.createElement(tFromNode.tagName));
         for(var j = 0 ; j != tFromNode.attributes.length; ++j)
         {
            if (tFromNode.attributes[j].nodeValue)
               tTemp.setAttribute(tFromNode.attributes[j].nodeName, tFromNode.attributes[j].nodeValue);
         }
         saw.replaceContents(tFromNode, tTemp);
         tOldNode.appendChild(tTemp);
      }
      else if (tFromNode.nodeType == 3)
      {
       // alert(tFromNode.nodeValue);
         var txtNode = document.createTextNode(tFromNode.nodeValue);
         tOldNode.appendChild(txtNode);
      }
      else
         alert("not handling: " + tFromNode.nodeType);
   }

}

function VTGetQueryXML(tDiv)
{
	var tIsland = saw.getXmlIsland();
	tIsland.loadXML(tDiv.getAttribute("queryXML"));

	return tIsland.selectSingleNode('saw:call');
}

function VTSetPage(tDiv, nPage)
{

	if(typeof(tDiv) == 'string')
		tDiv = document.getElementById(tDiv);


	if(tDiv == null)
		return false;

	var tXML = VTGetQueryXML(tDiv);
	tXML.setAttribute('page', nPage == null ? 1 : nPage);

	VTQueryTable(tDiv,tXML);

	return false;
}

var xy=0;

function VTQueryTable(tDiv, tXML)
{
	if(tXML == null)
		tXML = VTGetQueryXML(tDiv);

	tXML.setAttribute('embedDiv', tDiv.id);

	var tIFrame = window.frames[tDiv.id + 'IFrame' + window.frames.length];

	if(tIFrame == null)
	{
		tIFrame = saw.createHiddenIFrame(tDiv.id + 'IFrame', tDiv.id + 'IFrame');
		document.body.appendChild(tIFrame);
	}

	var sXML = tXML.xml;

	var tForm = tDiv.myForm;

	if(tForm == null || typeof(tForm) == 'undefined')
	{
		tForm = tDiv.myForm = document.createElement('form');
		tForm.setAttribute("name", tDiv.id+'Form');
		tForm.method = "post";
		document.body.appendChild(tForm);
	}

	tForm.action = saw.commandToURL('ValueTable');
	tForm.target = tIFrame.name;


	if(tForm.tableDef == null || typeof(tForm.tableDef) == 'undefined')
	{
   	saw.addHiddenInput(tForm, "embed", "true");
   	saw.addHiddenInput(tForm, "tableDef", "");
	}
	tForm.tableDef.value = sXML;

	tForm.submit();
}

function VTDisplayValues(tDiv, sColumns, sSubjectArea, sValueMessage, sWhere, 
                           sDisplayTimeZone, sDataTimeZoneOffset,
                           sType, uid, nPageValues, sDisplay, sSQL, sCallFunction, bRefresh, eid,
                           sDashboard, sDashboardPage, sSourcePath,dispalyFormat)
{
	var tXML = XUICreateElement(saw.xml.kSawNamespace, 'call');

	tXML.setAttribute('subjectArea',sSubjectArea);

   if (!nPageValues || (nPageValues && nPageValues < 0))
   {
      if (sType != "dropDown")
         nPageValues = 10;
	}
	if (bRefresh)
	   tXML.setAttribute('refresh',"true");
	tXML.setAttribute('pageValues',nPageValues);
	if (!sDisplay)
	   sDisplay = "all";
	tXML.setAttribute('display',sDisplay);
	tXML.setAttribute('valueMessage',sValueMessage);
	tXML.setAttribute('uniqueID',uid);
	
	if (sDisplayTimeZone)
	   tXML.setAttribute('displayTimeZone',sDisplayTimeZone);
	if (sDataTimeZoneOffset)   
	   tXML.setAttribute('dataTimeZoneOffset',sDataTimeZoneOffset);
	
	if (sType)
   	tXML.setAttribute('selectType',sType);
    if (sCallFunction)
      tXML.setAttribute('callFunction', sCallFunction);
    if(eid)
      tXML.setAttribute('eid', eid);  // for updating the number of rows returned for scrolling
      
   if (sDashboard)
      tXML.setAttribute('dashboard',sDashboard);
   if (sDashboardPage)
      tXML.setAttribute('dashboardPage',sDashboardPage);
   if (sSourcePath)
      tXML.setAttribute('sourcePath',sSourcePath);

	for(var i = 0 ; i != sColumns.length ; ++i)
	{
		var tColumn = XUICreateElement(saw.xml.kSawNamespace, 'column');

		tColumn.setAttribute('formula',sColumns[i]);
		if(dispalyFormat)
		{
			tColumn.appendChild(dispalyFormat.cloneNode(true));
		}

		tXML.appendChild(tColumn);
	}

   if (sSQL)
   {
      tXML.setAttribute('sql',sSQL);
   }
   else if(sWhere)
   {
      var tFilter = XUICreateElement(saw.xml.kSawNamespace, 'filter');

      if (typeof(sWhere) == 'string')
      {

         var tExpr = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

         XUISetXsiType(tExpr, saw.xml.kSawxNamespace, 'sql');

         XUISetElementText(tExpr, sWhere);

         tFilter.appendChild(tExpr);

	   }
	   else // assume it is a filter
	   {
	      tFilter.appendChild(sWhere.cloneNode(true));
	   }

      tXML.appendChild(tFilter);
   }

	VTQueryTable(tDiv,tXML);
}

function VTAlertValue(sXML)
{
	alert(VTValueXML(sXML).xml);
	return false;
}

function VTValueXML(sXML)
{
	var tIsland = saw.getXmlIsland();
	tIsland.loadXML(sXML);

	return tIsland.selectSingleNode('saw:value');
}
